class character {

  final int size = 20;
  final int radius = size/2;
  final int max_vel = 10;

  PVector pos = new PVector(width/2, height/2);
  PVector prev_pos = new PVector(0, 0);
  PVector vel = new PVector(0, 0);
  PVector acc = new PVector(0, 0);
  float   dec = 0.8;
  PVector wind = new PVector(0.05, 0);
  PVector gravity = new PVector(0, 0);

  ArrayList <PVector> closestPoints = new ArrayList <PVector> ();
  ArrayList <PVector> collidedPoints = new ArrayList <PVector> ();

  float angle = 0; // calculated
  float speed = 0; // calculated

  character() {
  }

  void render() {

    if (speed >= 2) {
      float x = lerp(0, 255, norm(speed, 2, 4));
      fill(255, 255-x, 255-x);
    } else if (speed <= 2) {
      float g = lerp(0, 255, norm(speed, 0, 2));
      fill(g, 255, g);
    } else {
      fill(255);
    }

    noStroke();
    ellipse(pos.x, pos.y, size, size);
    fill(255);
    ellipse(pos.x, pos.y, size/3, size/3);
    stroke(255, 0, 0);
  }

  void debugRender() {

    noFill();
    stroke(255, 100);
    strokeWeight(20);
    rect(gravity.x * 20, gravity.y * 20, width, height);
    //line(center.x, center.y, mouseX, mouseY);

    float px = pos.x + cos(angle)*10;
    float py = pos.y + sin(angle)*10;
    strokeWeight(2);
    stroke(0, 0, 255);
    line(pos.x, pos.y, px, py);
    strokeWeight(4);
  }

  void sim(ArrayList marks) {
  
    //gravity w/ accelerometer
    
    //float accelX, accelY;
    
    //accelX = device.accelerationX;
    //accelY = device.accelerationY * -1;
    
    
    //if(accelX < 1 && accelX > -1){
    // accelX = 0;
    //}
    
    //if(accelY < 1 && accelY > -1){
    // accelY = 0;
    //}
    
    //gravity = new PVector(accelX, accelY);
    
    //gravity w/ mouse
    
    gravity = new PVector(mouseX, mouseY);
    gravity.sub(center);
    
    gravity.normalize();
    gravity.mult(0.3);

    //line(width/2, height/2, mouse.x, mouse.y);

    // apply forces and do collision detection
    prev_pos = pos.get();
    isCollidingWithMark(marks);
    applyForce(gravity);
    vel.add(acc);
    vel.limit(max_vel);
    pos.add(vel);
   
    //boundary check
    if (pos.x > width - radius || pos.x < 0 + radius) {
      vel.x = vel.x * -dec;
      angle -= PI;
    }

    if (pos.y > height - radius || pos.y < 0 + radius) {
      vel.y = vel.y * -dec;
      angle -= PI;
    }
   
    if (pos.x > width - radius) {
      pos.x = width - radius;
    } else if (pos.x < 0 + radius) {
      pos.x = radius;
    }

    if (pos.y > height - radius) {
      pos.y = height - radius;
    } else if (pos.y < 0 + radius) {
      pos.y = radius;
    }

    acc.mult(0);

    angle = atan2(pos.y - prev_pos.y, pos.x - prev_pos.x);
    speed = vel.mag();
  }

  void applyForce(PVector force) {
    PVector f = force.get();
    f.div(size);
    acc.add(f);
  }

  boolean isCollidingWithMark(ArrayList <mark> marks) {

    closestPoints.clear();
    collidedPoints.clear();

    for (mark m: marks) {
      for (segment s: m.segments) {
        closestPoints.add(g.closestPointFromLineSegment(s.start, s.end, pos));
        PVector velChange = g.testCircleSegment(s.start, s.end, pos, size);  

        if (velChange != null) {  

          boolean isHit = false;

          if (speed >= 3 && s.strength == 2) {
            isHit = true;
          } else if (speed <= 1.5 && s.strength == 1) {
            isHit = true;
          } else if (s.strength == 0) {
            isHit = true;
          }

          if (isHit) {
            s.hits--;
            if (s.hits < 0) m.segments.remove(s);
          }

          collidedPoints.add(closestPoints.get(closestPoints.size()-1));
          velChange.mult(speed);
          vel.mult(0);
          acc.sub(velChange);

          return true;
        }
      }
    }
    return false;
  }

  void renderCollisions() {
    for (PVector p : closestPoints) {
      stroke(0, 0, 255);
      point(p.x, p.y);
      stroke(255);
    }
    for (PVector p : collidedPoints) {
      noStroke();
      fill(0, 0, 255);
      ellipse(p.x, p.y, 30, 30);
      fill(255);
      stroke(255);
    }
  }
}

